unit WebUserControl6;

//Tagprefix="owe" Tagname="showexample"

interface

uses 
  SysUtils, System.Data.SqlClient, System.Data, System.Drawing, System.Web, System.Web.UI,
  System.Web.UI.WebControls, System.Web.UI.HtmlControls;
     
type
    /// <summary>
    ///		Summary description for WebUserControl6.
    /// </summary>
  TWebUserControl6 = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		pidRandomProduct: System.Web.UI.WebControls.Label;
		pidProductName: System.Web.UI.WebControls.Literal;
		pidDeveloper: System.Web.UI.WebControls.Literal;
		pidAddress: System.Web.UI.WebControls.Literal;
		pidWebSite: System.Web.UI.WebControls.HyperLink;
		pidEmail: System.Web.UI.WebControls.HyperLink;
		pidTel: System.Web.UI.WebControls.Literal;
		pidFax: System.Web.UI.WebControls.Literal;
		pidContact: System.Web.UI.WebControls.Literal;
		lblAverageRating: System.Web.UI.WebControls.Label;
		imgAverageRating: System.Web.UI.WebControls.Image;
		pidAppType: System.Web.UI.WebControls.HyperLink;
		pidAppPayType: System.Web.UI.WebControls.HyperLink;
		pidImage: System.Web.UI.WebControls.Image;
		pidDescription: System.Web.UI.WebControls.Literal;
		hlAddReview: System.Web.UI.WebControls.HyperLink;
		dlReviewsHolder: System.Web.UI.WebControls.PlaceHolder;
    procedure OnInit(e: System.EventArgs); override;
  end;

implementation

uses reviews, productsDB;

procedure TWebUserControl6.Page_Load(sender: System.Object; e: System.EventArgs);
var
  _dlRev : ReviewsDataList;

  dr, drRating : SqlDataReader;
  product : TproductsDB;
  rid : string;

begin
  // Put user code to initialize the page here

  _dlRev := ReviewsDataList.create;
  dlReviewsHolder.Controls.Add(_dlRev);

  if IsPostBack then Exit;

      product:=TproductsDB.Create;
      try
        rid := Request.QueryString.Get('id');
        dr := product.GetProduct(StrToInt(rid));
        pidRandomProduct.Visible:=False;
      except
        dr:=product.GetRandomProduct
      end;

      if dr.Read = True then
      begin
        pidProductName.Text := dr['ProductName'].ToString;
        pidDeveloper.Text := dr['Name'].ToString;
        pidAddress.Text := dr['Address'].ToString;
        pidWebSite.Text := dr['WebSite'].ToString;
        pidWebSite.NavigateUrl := dr['WebSite'].ToString;
        pidEmail.Text := dr['Email'].ToString;
        pidEmail.NavigateURL := 'mailto:' + dr['Email'].ToString;
        pidTel.Text := dr['Tel'].ToString;
        pidFax.Text := dr['Fax'].ToString;
        pidContact.Text := dr['Contact'].ToString;

        pidAppType.Text := dr['AppType'].ToString;
        pidAppType.NavigateURL := 'webform3.aspx?apptype=' + dr['AppType'].ToString;
        pidAppPayType.Text := dr['AppPayType'].ToString;
        pidAppPayType.NavigateURL := 'webform3.aspx?apptpaytype=' + dr['AppPayType'].ToString;

        pidDescription.Text := dr['Description'].ToString;

        if dr['ImageName'].ToString <> '' then
        begin
          pidImage.Style.Add('hspace','10');
          pidImage.Style.Add('vspace','10');
          pidImage.ImageURL:= dr['ImageName'].ToString
        end
        else
		      pidImage.Style.Add('display','none');

				//reviews
				hlAddReview.Text:='Add your review!';
				hlAddReview.NavigateURL:='webform8.aspx?ID=' + dr['ProductID'].ToString + '&PName=' + pidProductName.Text;
				_dlRev.ProductID := Integer(dr['ProductID']);

				drRating := product.GetAverageReview(Integer(dr['ProductID']));
				if (drRating.Read) and (drRating['cid'].ToString <> '0') then
				begin
					lblAverageRating.Style.Add('color','darkgray');
					lblAverageRating.text:='Rated : ' + drRating['cavg'].ToString  + ' <br> based on ' + drRating['cid'].ToString + ' reviews';
					imgAverageRating.ImageURL:='gfx/rate' + drRating['cavg'].ToString + '.gif'
				end
				else
				begin
					lblAverageRating.Visible:=False;
					imgAverageRating.Visible:=False;
				end;



      end;

      dr.Close;

end;

procedure TWebUserControl6.OnInit(e: System.EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
///		Required method for Designer support - do not modify
///		the contents of this method with the code editor.
/// </summary>
procedure TWebUserControl6.InitializeComponent;
begin
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.
